// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     mojo/services/network/public/interfaces/http_server.mojom
//

package org.chromium.mojom.mojo;

class HttpServerDelegate_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<HttpServerDelegate, HttpServerDelegate.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<HttpServerDelegate, HttpServerDelegate.Proxy>() {
    
        public String getName() {
            return "mojo::HttpServerDelegate";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, HttpServerDelegate impl) {
            return new Stub(core, impl);
        }
    
        public HttpServerDelegate[] buildArray(int size) {
          return new HttpServerDelegate[size];
        }
    };

    private static final int ON_CONNECTED_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements HttpServerDelegate.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void onConnected(HttpConnection connection, org.chromium.mojo.bindings.InterfaceRequest<HttpConnectionDelegate> delegate) {
            HttpServerDelegateOnConnectedParams _message = new HttpServerDelegateOnConnectedParams();
            _message.connection = connection;
            _message.delegate = delegate;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(ON_CONNECTED_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<HttpServerDelegate> {

        Stub(org.chromium.mojo.system.Core core, HttpServerDelegate impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                HttpServerDelegate_Internal.MANAGER, messageWithHeader);
                    case ON_CONNECTED_ORDINAL: {
                        HttpServerDelegateOnConnectedParams data =
                                HttpServerDelegateOnConnectedParams.deserialize(messageWithHeader.getPayload());
                        getImpl().onConnected(data.connection, data.delegate);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), HttpServerDelegate_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class HttpServerDelegateOnConnectedParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 24;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(24, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public HttpConnection connection;
        public org.chromium.mojo.bindings.InterfaceRequest<HttpConnectionDelegate> delegate;
    
        private HttpServerDelegateOnConnectedParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public HttpServerDelegateOnConnectedParams() {
            this(0);
        }
    
        public static HttpServerDelegateOnConnectedParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static HttpServerDelegateOnConnectedParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            HttpServerDelegateOnConnectedParams result = new HttpServerDelegateOnConnectedParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.connection = decoder0.readServiceInterface(8, false, HttpConnection.MANAGER);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.delegate = decoder0.readInterfaceRequest(16, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(connection, 8, false, HttpConnection.MANAGER);
            encoder0.encode(delegate, 16, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            HttpServerDelegateOnConnectedParams other = (HttpServerDelegateOnConnectedParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.connection, other.connection))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.delegate, other.delegate))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(connection);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(delegate);
            return result;
        }
    }

}

